/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.ICustomElement;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.blocks.BlockInterface;
import noppes.npcs.blocks.CustomBlock;
import noppes.npcs.blocks.tiles.CustomTileEntityChest;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.util.Util;

public class CustomChest
extends BlockInterface
implements ICustomElement {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public NBTTagCompound nbtData;
    private AxisAlignedBB FULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public boolean isChest = false;

    public CustomChest(Material material, NBTTagCompound nbtBlock) {
        super(material);
        this.nbtData = nbtBlock;
        this.setName("custom_" + nbtBlock.func_74779_i("RegistryName"));
        this.field_149758_A = true;
        this.func_149672_a(CustomBlock.getNbtSoundType(nbtBlock.func_74779_i("SoundType")));
        this.func_149711_c(0.0f);
        this.func_149752_b(10.0f);
        if (nbtBlock.func_150297_b("Hardness", 5)) {
            this.func_149711_c(nbtBlock.func_74760_g("Hardness"));
        }
        if (nbtBlock.func_150297_b("Resistance", 5)) {
            this.func_149752_b(nbtBlock.func_74760_g("Resistance"));
        }
        if (nbtBlock.func_150297_b("LightLevel", 5)) {
            this.func_149715_a(nbtBlock.func_74760_g("LightLevel"));
        }
        if (nbtBlock.func_150297_b("IsChest", 1)) {
            this.isChest = this.nbtData.func_74767_n("IsChest");
        }
        this.setAABB(nbtBlock.func_150295_c("AABB", 6));
        this.func_149647_a(CustomRegisters.tabBlocks);
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CustomTileEntityChest) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((CustomTileEntityChest)tile));
        }
        worldIn.func_175666_e(pos, (Block)this);
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new CustomTileEntityChest();
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        if (this.isChest) {
            return CHEST_AABB;
        }
        return this.FULL_AABB;
    }

    @Override
    public String getCustomName() {
        return this.nbtData.func_74779_i("RegistryName");
    }

    @Override
    public INbt getCustomNbt() {
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(this.nbtData);
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        if (this.isChest) {
            return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
        }
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab != CustomRegisters.tabBlocks && tab != CreativeTabs.field_78027_g) {
            return;
        }
        if (this.nbtData != null && this.nbtData.func_150297_b("ShowInCreative", 1) && !this.nbtData.func_74767_n("ShowInCreative")) {
            return;
        }
        items.add((Object)new ItemStack((Block)this));
        if (tab == CustomRegisters.tabBlocks) {
            Util.instance.sort(items);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(@Nonnull IBlockState state) {
        return true;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    public boolean func_180639_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer playerIn, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || !(playerIn instanceof EntityPlayerMP)) {
            return true;
        }
        if (this.isChest && worldIn.func_180495_p(pos.func_177984_a()).doesSideBlockChestOpening((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN)) {
            return true;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CustomTileEntityChest) {
            if (((CustomTileEntityChest)tile).func_174893_q_()) {
                boolean isOwner = false;
                TextComponentTranslation message = new TextComponentTranslation("container.isLocked", new Object[]{"\u00a7r" + ((CustomTileEntityChest)tile).func_70005_c_()});
                message.func_150256_b().func_150238_a(TextFormatting.RED);
                if (!((CustomTileEntityChest)tile).func_174891_i().func_180160_a()) {
                    String locked = ((CustomTileEntityChest)tile).func_174891_i().func_180159_b();
                    isOwner = locked.contains(playerIn.func_70005_c_());
                    TextComponentString added = new TextComponentString(" ");
                    added.func_150256_b().func_150238_a(TextFormatting.GRAY);
                    added.func_150257_a((ITextComponent)new TextComponentTranslation("companion.owner", new Object[0]));
                    TextComponentString names = new TextComponentString(": " + locked);
                    names.func_150256_b().func_150238_a(TextFormatting.RESET);
                    added.func_150257_a((ITextComponent)names);
                    message.func_150257_a((ITextComponent)added);
                }
                if (!isOwner) {
                    playerIn.func_145747_a((ITextComponent)message);
                    ((EntityPlayerMP)playerIn).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(SoundEvents.field_187654_U, SoundCategory.BLOCKS, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, 1.0f));
                    if (!playerIn.func_184812_l_()) {
                        return true;
                    }
                    playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gui.allowed", new Object[0]));
                }
            }
            if (this.nbtData.func_150297_b("GUIColor", 3)) {
                ((CustomTileEntityChest)tile).guiColor = this.nbtData.func_74762_e("GUIColor");
            }
            if (this.nbtData.func_150297_b("GUIColor", 11)) {
                ((CustomTileEntityChest)tile).guiColor = -1;
                ((CustomTileEntityChest)tile).guiColorArr = this.nbtData.func_74759_k("GUIColor");
            }
            CustomNpcs.proxy.fixTileEntityData(tile);
            NoppesUtilServer.sendOpenGui(playerIn, EnumGuiType.CustomContainer, null, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_176213_c(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (worldIn.field_72995_K || FACING == null) {
            return;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
            enumfacing = EnumFacing.SOUTH;
        } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
            enumfacing = EnumFacing.NORTH;
        } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
            enumfacing = EnumFacing.EAST;
        } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
            enumfacing = EnumFacing.WEST;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CustomTileEntityChest) {
            ((CustomTileEntityChest)tile).setBlock(this);
        }
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof CustomTileEntityChest) {
            if (stack.func_77942_o() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
                tile.func_145839_a(stack.func_77978_p().func_74775_l("BlockEntityTag"));
            } else {
                ((CustomTileEntityChest)tile).setBlock(this);
            }
        }
    }

    private void setAABB(NBTTagList tagList) {
        double[] v = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        for (int i = 0; i < 6; ++i) {
            double s;
            double d = s = i < 3 ? 0.0 : 1.0;
            if (i < tagList.func_74745_c()) {
                s = tagList.func_150309_d(i);
            }
            v[i] = s;
        }
        this.FULL_AABB = new AxisAlignedBB(v[0], v[1], v[2], v[3], v[4], v[5]);
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, @Nonnull Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, @Nonnull Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Override
    public int getType() {
        if (this.nbtData != null && this.nbtData.func_150297_b("BlockType", 1)) {
            return this.nbtData.func_74771_c("BlockType");
        }
        return 2;
    }
}

